 

/****** Object:  StoredProcedure [dbo].[P_BAIXA_GRUPO_ECONOMICO_AUTOMATICA]    Script Date: 11/18/2013 17:37:55 ******/
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[P_BAIXA_GRUPO_ECONOMICO_AUTOMATICA]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[P_BAIXA_GRUPO_ECONOMICO_AUTOMATICA]
GO
 

/****** Object:  StoredProcedure [dbo].[P_BAIXA_GRUPO_ECONOMICO_AUTOMATICA]    Script Date: 11/18/2013 17:37:55 ******/
SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO


--EXECUTE P_BAIXA_GRUPO_ECONOMICO_AUTOMATICA '20131001','20131031','20131031'
CREATE PROCEDURE [dbo].[P_BAIXA_GRUPO_ECONOMICO_AUTOMATICA] (
											@DT_INI DATETIME,	
											@DT_FIM DATETIME,
											@DT_BAIXA DATETIME)
AS
CREATE TABLE #RsDup (CD_REG INT IDENTITY(1,1),
					  CD_EMP_ORIG		INT,
					  CD_FILIAL_ORIG	INT,
					  CD_GRP_ECON_ORIG	INT,
					  CD_RC_DEB			INT,
					  NR_DP_DEB			INT,
					  PARC_DEB			INT,
					  NM_DEST_DEB		VARCHAR(25),	
					  VLR_DUP_ORIG		MONEY,
					  CD_EMP_DEST		INT,
					  CD_FILIAL_DEST	INT,
					  CD_GRP_ECON_DEST	INT,
					  CD_PG_CRED		INT,
					  NR_DP_DEST		INT,
					  PARC_DEST			INT,
					  NM_ORIG_DEST		VARCHAR(25),
					  CD_TP_FORN		INT,	
					  VLR_DP_DEST		MONEY)
DECLARE @CD_BC_LANC INT
--SET  @DT_BAIXA = CONVERT(CHAR(10),GETDATE(),112)
--SET  @DT_BAIXA = '20091204'
 
PRINT 'Buscando duplicatas do grupo econmico'
INSERT INTO #RsDup
Select 	
	DISTINCT 
	RC_DEB_EST_NF_SAI.CD_EMP,
	RC_DEB_EST_NF_SAI.CD_FILIAL,
    g_orig.CD_GRP_ECON,
	RC_DEB.CD_RC_DEB,
	RC_DEB.NR_DP,
	RC_DEB.PARC,
	LEFT(RC_CLI.RZ_CLI,25),
	RC_DEB.VLR_DP, 
	PG_CRED_EST_NF_ENT.CD_EMP,
	PG_CRED_EST_NF_ENT.CD_FILIAL,
	g_dest.CD_GRP_ECON,
	PG_CRED.CD_PG_CRED, 
	PG_CRED.NR_DP,
	PG_CRED.PARC,
	LEFT(PG_FORN.RZ_FORN,25),	
	ISNULL(PG_FORN.CD_TP_FORN,0),
	PG_CRED.VLR_DP
From 
	V_EST_NF_SAI_TRANSF_PRC_FILIAL_RC_CLI 
	INNER JOIN RC_DEB_EST_NF_SAI ON 
	V_EST_NF_SAI_TRANSF_PRC_FILIAL_RC_CLI.CD_EMP = RC_DEB_EST_NF_SAI.CD_EMP AND 
	V_EST_NF_SAI_TRANSF_PRC_FILIAL_RC_CLI.CD_FILIAL = RC_DEB_EST_NF_SAI.CD_FILIAL AND 
	V_EST_NF_SAI_TRANSF_PRC_FILIAL_RC_CLI.CD_NF = RC_DEB_EST_NF_SAI.CD_NF
	INNER JOIN RC_DEB ON 
	RC_DEB_EST_NF_SAI.CD_EMP = RC_DEB.CD_EMP AND 
	RC_DEB_EST_NF_SAI.CD_FILIAL = RC_DEB.CD_FILIAL AND 
    RC_DEB_EST_NF_SAI.NR_DP = RC_DEB.NR_DP AND 
	RC_DEB_EST_NF_SAI.ANO = RC_DEB.ANO 
	INNER JOIN RC_CLI ON
	RC_DEB.CD_EMP = RC_CLI.CD_EMP AND
	RC_DEB.CD_CLI = RC_CLI.CD_CLI
	INNER JOIN PG_CRED_EST_NF_ENT ON 
	V_EST_NF_SAI_TRANSF_PRC_FILIAL_RC_CLI.CD_EMP = PG_CRED_EST_NF_ENT.CD_EMP AND 
	V_EST_NF_SAI_TRANSF_PRC_FILIAL_RC_CLI.CD_FILIAL_DEST = PG_CRED_EST_NF_ENT.CD_FILIAL AND 
	V_EST_NF_SAI_TRANSF_PRC_FILIAL_RC_CLI.CD_NF_ENT = PG_CRED_EST_NF_ENT.CD_NF 
	INNER JOIN PG_CRED ON 
	PG_CRED_EST_NF_ENT.CD_EMP = PG_CRED.CD_EMP AND 
	PG_CRED_EST_NF_ENT.CD_FILIAL = PG_CRED.CD_FILIAL AND 
    PG_CRED_EST_NF_ENT.NR_DP = PG_CRED.NR_DP AND 
	PG_CRED_EST_NF_ENT.ANO = PG_CRED.ANO

	INNER JOIN PG_FORN ON
	PG_CRED.CD_EMP = PG_FORN.CD_EMP AND
	PG_CRED.CD_FORN = PG_FORN.CD_FORN

    INNER JOIN PRC_GRP_ECON_PRC_FILIAL p_orig ON 
    V_EST_NF_SAI_TRANSF_PRC_FILIAL_RC_CLI.CD_EMP = p_orig.CD_EMP AND 
    V_EST_NF_SAI_TRANSF_PRC_FILIAL_RC_CLI.CD_FILIAL = p_orig.CD_FILIAL
    INNER JOIN PRC_GRP_ECON g_orig ON 
    p_orig.CD_GRP_ECON = g_orig.CD_GRP_ECON

    INNER JOIN PRC_GRP_ECON_PRC_FILIAL p_dest ON 
    V_EST_NF_SAI_TRANSF_PRC_FILIAL_RC_CLI.CD_EMP = p_dest.CD_EMP AND 
    V_EST_NF_SAI_TRANSF_PRC_FILIAL_RC_CLI.CD_FILIAL_DEST = p_dest.CD_FILIAL
    INNER JOIN PRC_GRP_ECON g_dest ON 
    p_dest.CD_GRP_ECON = g_dest.CD_GRP_ECON
Where  
	V_EST_NF_SAI_TRANSF_PRC_FILIAL_RC_CLI.CD_EMP =1 
	AND V_EST_NF_SAI_TRANSF_PRC_FILIAL_RC_CLI.DT_ENT BETWEEN @DT_INI AND @DT_FIM
	AND V_EST_NF_SAI_TRANSF_PRC_FILIAL_RC_CLI.STS_NF = 0
	AND RC_DEB.STS_DP = 0 
	AND PG_CRED.STS_DP = 0

 
PRINT 'Gerando baixa do contas a receber'
INSERT INTO RC_CRED (CD_EMP,CD_FILIAL,CD_RC_DEB,CD_DP_LANC,DT_PAG,
						VL_PGTO,VL_JUR,VL_DESC,CD_HIST,CD_USU,HIST,CD_CNT,
						CD_DOC,VLR_COMIS,VLR_GLOSA,VLR_IMPOSTO)
SELECT 
	p.CD_EMP_ORIG,
	p.CD_FILIAL_ORIG,
	p.CD_RC_DEB,
	1,
	@DT_BAIXA,
	VLR_DUP_ORIG,
	0,
	0,
	9,
	1,
	'RECEBTO DUP.  N ' + CONVERT(VARCHAR(20),NR_DP_DEB) + ' - ' + CONVERT(VARCHAR(3),PARC_DEB) + ' FIL.: '+ CONVERT(VARCHAR(10),CD_FILIAL_DEST) + ' - ' + NM_DEST_DEB,
	CD_CNT_TRANSA_CRED, --Codigo da conta bancria
	1 CD_DOC,
	0 VLR_COMIS,
	0 VLR_GLOSA,
	0 VLR_IMPOSTO
FROM
	#RsDup p 
	INNER JOIN PRC_GRP_ECON_BAIXA_AUTOMATICA ON 
	p.CD_GRP_ECON_ORIG = PRC_GRP_ECON_BAIXA_AUTOMATICA.CD_GRP_ECON_ORIG AND 
	p.CD_GRP_ECON_DEST = PRC_GRP_ECON_BAIXA_AUTOMATICA.CD_GRP_ECON_DEST
	
	LEFT JOIN RC_CRED ON 
	p.CD_EMP_ORIG	 = RC_CRED.CD_EMP AND 
	P.CD_FILIAL_ORIG = RC_CRED.CD_FILIAL AND
	p.CD_RC_DEB		 = RC_CRED.CD_RC_DEB
WHERE
	RC_CRED.CD_RC_DEB IS NULL
	
ORDER BY
	p.CD_REG

SET @CD_BC_LANC =0
SET @CD_BC_LANC = ISNULL((SELECT MAX(CD_BC_LANC) FROM BC_LANC WHERE CD_EMP = 1),0)

--Gerando lancamento bancario do contas a receber
PRINT 'Gerando lancamento bancario do contas a receber'
INSERT INTO BC_LANC (CD_EMP,CD_BC_LANC,VLR_LANC,CD_CNT,HIST_LANC,
						CD_DOC,TP_LANC,DT_LANCTO,DT_CAD,DT_ULT_ALT,
						CD_USU,FC,HIST_LANC_CPL,CD_TP_LANC,
						SLD_INI,ORIG_LANC,DT_COMP)
SELECT 
	CD_EMP_ORIG,
	@CD_BC_LANC + CD_REG,
	VLR_DUP_ORIG,
	CD_CNT_TRANSA_CRED, --Codigo da conta bancria,
	'RECEBTO DUP.  N ' + CONVERT(VARCHAR(20),NR_DP_DEB) + ' - ' + CONVERT(VARCHAR(3),PARC_DEB) + ' FIL.: '+ CONVERT(VARCHAR(10),CD_FILIAL_DEST) + ' - ' + NM_DEST_DEB,
	1,
	0, --Dbito no bancrio do contas a receber
	@DT_BAIXA,
	@DT_BAIXA,
	NULL,
	1,
	0,
	'',
	0,
	0,
	0,	
	@DT_BAIXA
FROM
	#RsDup p INNER JOIN PRC_GRP_ECON_BAIXA_AUTOMATICA ON 
	p.CD_GRP_ECON_ORIG = PRC_GRP_ECON_BAIXA_AUTOMATICA.CD_GRP_ECON_ORIG AND 
	p.CD_GRP_ECON_DEST = PRC_GRP_ECON_BAIXA_AUTOMATICA.CD_GRP_ECON_DEST
ORDER BY
	p.CD_REG

--Gerando vnculo do bancrio como a baixa do contas a receber
PRINT 'Gerando vnculo do bancrio como a baixa do contas a receber'
INSERT INTO RC_CRED_BC_LANC (CD_EMP,CD_FILIAL,CD_RC_DEB,CD_DP_LANC,CD_BC_LANC)
SELECT 
	CD_EMP_ORIG,
	CD_FILIAL_ORIG,
	CD_RC_DEB,
	1,
	@CD_BC_LANC + CD_REG
FROM
	#RsDup p INNER JOIN PRC_GRP_ECON_BAIXA_AUTOMATICA ON 
	p.CD_GRP_ECON_ORIG = PRC_GRP_ECON_BAIXA_AUTOMATICA.CD_GRP_ECON_ORIG AND 
	p.CD_GRP_ECON_DEST = PRC_GRP_ECON_BAIXA_AUTOMATICA.CD_GRP_ECON_DEST
ORDER BY
	p.CD_REG

--Gerando Baixa do contas a pagar
PRINT 'Gerando Baixa do contas a pagar'
INSERT INTO PG_DEB (CD_EMP,CD_FILIAL,CD_PG_CRED,CD_DP_LANC,DT_PAG,VL_PGTO,VL_JUR,
						VL_DESC,VL_IMP,CD_HIST,CD_USU,HIST,CD_CNT,CD_DOC,V_NF,
						VLR_DEVOLUCAO,VLR_GLOSA,VLR_IMPOSTO,AUTENTICACAO)
SELECT DISTINCT
	P.CD_EMP_DEST,
	P.CD_FILIAL_DEST,
	P.CD_PG_CRED,
	1,
	@DT_BAIXA,
	VLR_DP_DEST,
	0,
	0,
	0,
	9,
	1 CD_USU,
	'PGTO DUP.  N ' + CONVERT(VARCHAR(20),NR_DP_DEST) + ' - ' + CONVERT(VARCHAR(20),PARC_DEST) + ' FIL.: '+ CONVERT(VARCHAR(20),CD_FILIAL_ORIG) + ' - ' + NM_ORIG_DEST,
	CD_CNT_TRANSA_DEB, --Codigo da conta bancria
	1 CD_DOC,
	0 V_NF,
	0 VLR_DEVOLUCAO,
	0 VLR_GLOSA,
	0 VLR_IMPOSTO,
	0 AUTENTICACAO
FROM
	#RsDup p INNER JOIN PRC_GRP_ECON_BAIXA_AUTOMATICA ON 
	p.CD_GRP_ECON_ORIG = PRC_GRP_ECON_BAIXA_AUTOMATICA.CD_GRP_ECON_ORIG AND 
	p.CD_GRP_ECON_DEST = PRC_GRP_ECON_BAIXA_AUTOMATICA.CD_GRP_ECON_DEST

	LEFT JOIN PG_DEB ON 
	p.CD_EMP_DEST    = PG_DEB.CD_EMP AND 
	p.CD_FILIAL_DEST = PG_DEB.CD_FILIAL AND 
	p.CD_PG_CRED	 = PG_DEB.CD_PG_CRED 
WHERE
	PG_DEB.CD_PG_CRED IS NULL
 

SET @CD_BC_LANC =0
SET @CD_BC_LANC = ISNULL((SELECT MAX(CD_BC_LANC) FROM BC_LANC WHERE CD_EMP = 1),0)

PRINT 'Gerando lancamento bancario do contas a pagar'
INSERT INTO BC_LANC (CD_EMP,CD_BC_LANC,VLR_LANC,CD_CNT,HIST_LANC,CD_DOC,TP_LANC,DT_LANCTO,
						DT_CAD,DT_ULT_ALT,CD_USU,FC,HIST_LANC_CPL,
						CD_TP_LANC,SLD_INI,ORIG_LANC,DT_COMP)
SELECT 
	CD_EMP_ORIG,
	@CD_BC_LANC + CD_REG,
	VLR_DUP_ORIG,
	CD_CNT_TRANSA_DEB, --Codigo da conta bancria,
	'PGTO DUP.  N ' + CONVERT(VARCHAR(20),NR_DP_DEST) + ' - ' + CONVERT(VARCHAR(20),PARC_DEST) + ' FIL.: '+ CONVERT(VARCHAR(20),CD_FILIAL_ORIG) + ' - ' + NM_ORIG_DEST,
	1,
	1, --Crdito no bancrio do contas a pagar
	@DT_BAIXA,
	@DT_BAIXA,
	NULL,
	1,
	0,
	'',
	0,
	0,
	0,	
	@DT_BAIXA
FROM
	#RsDup p INNER JOIN PRC_GRP_ECON_BAIXA_AUTOMATICA ON 
	p.CD_GRP_ECON_ORIG = PRC_GRP_ECON_BAIXA_AUTOMATICA.CD_GRP_ECON_ORIG AND 
	p.CD_GRP_ECON_DEST = PRC_GRP_ECON_BAIXA_AUTOMATICA.CD_GRP_ECON_DEST
ORDER BY
	p.CD_REG

--Gerando vnculo do bancrio com o contas a pagar
PRINT 'Gerando vnculo do bancrio com o contas a pagar'
INSERT INTO PG_DEB_BC_LANC (CD_EMP,CD_FILIAL,CD_PG_CRED,CD_DP_LANC,CD_BC_LANC)
SELECT 
	P.CD_EMP_DEST,
	P.CD_FILIAL_DEST,
	P.CD_PG_CRED,
	1,
	@CD_BC_LANC + CD_REG
FROM
	#RsDup p INNER JOIN PRC_GRP_ECON_BAIXA_AUTOMATICA ON 
	p.CD_GRP_ECON_ORIG = PRC_GRP_ECON_BAIXA_AUTOMATICA.CD_GRP_ECON_ORIG AND 
	p.CD_GRP_ECON_DEST = PRC_GRP_ECON_BAIXA_AUTOMATICA.CD_GRP_ECON_DEST

	LEFT JOIN PG_DEB_BC_LANC ON 
	p.CD_EMP_DEST    = PG_DEB_BC_LANC.CD_EMP AND 
	p.CD_FILIAL_DEST = PG_DEB_BC_LANC.CD_FILIAL AND 
	p.CD_PG_CRED	 = PG_DEB_BC_LANC.CD_PG_CRED 
WHERE
	PG_DEB_BC_LANC.CD_PG_CRED IS NULL
ORDER BY
	p.CD_REG

PRINT 'ALTERA O SALDO DA DUP NA RC_DEB'
UPDATE
	r
SET
	r.SLD_DP=0,
	r.STS_DP=1
FROM 
	#RsDup p INNER JOIN PRC_GRP_ECON_BAIXA_AUTOMATICA ON 
	p.CD_GRP_ECON_ORIG = PRC_GRP_ECON_BAIXA_AUTOMATICA.CD_GRP_ECON_ORIG AND 
	p.CD_GRP_ECON_DEST = PRC_GRP_ECON_BAIXA_AUTOMATICA.CD_GRP_ECON_DEST
	INNER JOIN RC_DEB r ON
	p.CD_EMP_ORIG = r.CD_EMP AND
	p.CD_FILIAL_ORIG = r.CD_FILIAL AND
	p.CD_RC_DEB = r.CD_RC_DEB

PRINT 'ALTERA O SALDO DA DUP NA PG_CRED'
UPDATE
	pg
SET
	pg.SLD_DP=0,
	pg.STS_DP=1
FROM 
	#RsDup p INNER JOIN PRC_GRP_ECON_BAIXA_AUTOMATICA ON 
	p.CD_GRP_ECON_ORIG = PRC_GRP_ECON_BAIXA_AUTOMATICA.CD_GRP_ECON_ORIG AND 
	p.CD_GRP_ECON_DEST = PRC_GRP_ECON_BAIXA_AUTOMATICA.CD_GRP_ECON_DEST
	INNER JOIN PG_CRED pg ON
	p.CD_EMP_DEST = pg.CD_EMP AND
	p.CD_FILIAL_DEST = pg.CD_FILIAL AND
	p.CD_PG_CRED = pg.CD_PG_CRED


GO


